<?php
/**
 * Get Active Chats Endpoint
 * Returns active and escalated chat sessions for vendor
 */

header('Content-Type: application/json');
require_once __DIR__ . '/../includes/db.php';
require_once __DIR__ . '/../includes/auth_middleware.php';

if ($_SERVER['REQUEST_METHOD'] !== 'GET') {
    http_response_code(405);
    echo json_encode(['error' => 'Method not allowed']);
    exit;
}

try {
    // Authenticate vendor
    $vendorId = AuthMiddleware::getVendorId();
    
    $db = getDB();
    $stmt = $db->prepare("
        SELECT 
            s.id,
            s.chatbot_id,
            s.session_id,
            s.status,
            s.created_at,
            s.updated_at,
            c.bot_name,
            (SELECT COUNT(*) FROM chat_logs WHERE session_id = s.session_id AND role = 'user') as message_count
        FROM active_sessions s
        INNER JOIN chatbots c ON s.chatbot_id = c.id
        WHERE s.vendor_id = ? AND s.status IN ('active', 'escalated')
        ORDER BY s.updated_at DESC
    ");
    $stmt->execute([$vendorId]);
    $sessions = $stmt->fetchAll();
    
    // Get recent messages for each session
    foreach ($sessions as &$session) {
        $stmt = $db->prepare("
            SELECT role, message, created_at
            FROM chat_logs
            WHERE session_id = ? AND vendor_id = ?
            ORDER BY created_at DESC
            LIMIT 10
        ");
        $stmt->execute([$session['session_id'], $vendorId]);
        $messages = $stmt->fetchAll();
        $session['recent_messages'] = array_reverse($messages);
    }
    
    http_response_code(200);
    echo json_encode([
        'success' => true,
        'sessions' => $sessions,
        'count' => count($sessions)
    ]);
    
} catch (Exception $e) {
    error_log("Get active chats error: " . $e->getMessage());
    http_response_code(500);
    echo json_encode(['error' => $e->getMessage()]);
}
