<?php
/**
 * Get Chatbot Info Endpoint
 * Returns chatbot configuration for widget initialization
 */

header('Content-Type: application/json');
header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Methods: POST, OPTIONS');
header('Access-Control-Allow-Headers: Content-Type');

if ($_SERVER['REQUEST_METHOD'] === 'OPTIONS') {
    http_response_code(200);
    exit;
}

require_once __DIR__ . '/../includes/db.php';

if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    http_response_code(405);
    echo json_encode(['error' => 'Method not allowed']);
    exit;
}

try {
    $input = json_decode(file_get_contents('php://input'), true);
    
    if (empty($input['vendor_id']) || empty($input['chatbot_id'])) {
        http_response_code(400);
        echo json_encode(['error' => 'vendor_id and chatbot_id are required']);
        exit;
    }
    
    $vendorId = (int) $input['vendor_id'];
    $chatbotId = (int) $input['chatbot_id'];
    
    $db = getDB();
    $stmt = $db->prepare("
        SELECT bot_name, welcome_message
        FROM chatbots
        WHERE id = ? AND vendor_id = ?
    ");
    $stmt->execute([$chatbotId, $vendorId]);
    $chatbot = $stmt->fetch();
    
    if (!$chatbot) {
        http_response_code(404);
        echo json_encode(['error' => 'Chatbot not found']);
        exit;
    }
    
    http_response_code(200);
    echo json_encode([
        'success' => true,
        'bot_name' => $chatbot['bot_name'],
        'welcome_message' => $chatbot['welcome_message']
    ]);
    
} catch (Exception $e) {
    error_log("Get chatbot info error: " . $e->getMessage());
    http_response_code(500);
    echo json_encode(['error' => $e->getMessage()]);
}
