<?php
/**
 * Environment Variable Loader
 * Loads environment variables from .env file using vlucas/phpdotenv
 */

// Only load if Dotenv class exists (installed via Composer)
if (class_exists('Dotenv\Dotenv')) {
    $dotenv = Dotenv\Dotenv::createImmutable(__DIR__ . '/..');
    $dotenv->load();
    
    // Ensure required variables are set
    $dotenv->required([
        'DB_HOST',
        'DB_NAME',
        'DB_USER',
        'JWT_SECRET_KEY',
        'OPENAI_API_KEY',
        'QDRANT_API_KEY',
        'QDRANT_CLUSTER_URL'
    ])->notEmpty();
} else {
    // Fallback: Use getenv() if Dotenv is not available
    // This allows the app to work with environment variables set by the server
    if (!function_exists('getenv')) {
        function getenv($key, $default = null) {
            return $_ENV[$key] ?? $_SERVER[$key] ?? $default;
        }
    }
}
