<?php
/**
 * Pusher Configuration
 * Initializes Pusher client for real-time communication
 */

require_once __DIR__ . '/env_loader.php';

use Pusher\Pusher;
use Pusher\PusherException;

class PusherConfig {
    private static $instance = null;
    
    /**
     * Get Pusher instance (singleton)
     * 
     * @return Pusher Pusher client instance
     */
    public static function getInstance() {
        if (self::$instance === null) {
            $appId = getenv('PUSHER_APP_ID');
            $key = getenv('PUSHER_KEY');
            $secret = getenv('PUSHER_SECRET');
            $cluster = getenv('PUSHER_CLUSTER') ?: 'us2';
            $useTLS = true;
            
            if (empty($appId) || empty($key) || empty($secret)) {
                throw new Exception("Pusher credentials are not set in environment variables");
            }
            
            try {
                self::$instance = new Pusher(
                    $key,
                    $secret,
                    $appId,
                    [
                        'cluster' => $cluster,
                        'useTLS' => $useTLS
                    ]
                );
            } catch (PusherException $e) {
                error_log("Pusher initialization error: " . $e->getMessage());
                throw new Exception("Failed to initialize Pusher: " . $e->getMessage());
            }
        }
        
        return self::$instance;
    }
    
    /**
     * Get Pusher configuration for client-side JavaScript
     * 
     * @return array Pusher config array
     */
    public static function getClientConfig() {
        return [
            'key' => getenv('PUSHER_KEY'),
            'cluster' => getenv('PUSHER_CLUSTER') ?: 'us2'
        ];
    }
}
